﻿namespace Hims.Api.Filters
{
    using System.Linq;
    using Microsoft.AspNetCore.Authorization;
    using Microsoft.OpenApi.Models;
    using Swashbuckle.AspNetCore.SwaggerGen;

    /// <inheritdoc />
    public class AppendAuthorizeToSummaryOperationFilter : IOperationFilter
    {
        /// <summary>
        /// The filter.
        /// </summary>
        private readonly AppendAuthorizeToSummaryOperationFilter<AuthorizeAttribute> filter;

        /// <summary>
        /// Initializes a new instance of the <see cref="AppendAuthorizeToSummaryOperationFilter"/> class.
        /// </summary>
        public AppendAuthorizeToSummaryOperationFilter()
        {
            var policySelector = new PolicySelectorWithLabel<AuthorizeAttribute>
            {
                Label = "Policies",
                Selector = authAttributes =>
                    authAttributes
                        .Where(a => !string.IsNullOrEmpty(a.Policy))
                        .Select(a => a.Policy)
            };

            var rolesSelector = new PolicySelectorWithLabel<AuthorizeAttribute>
            {
                Label = "Roles",
                Selector = authAttributes =>
                    authAttributes
                        .Where(a => !string.IsNullOrEmpty(a.Roles))
                        .Select(a => a.Roles)
            };

            this.filter = new AppendAuthorizeToSummaryOperationFilter<AuthorizeAttribute>(new[] { policySelector, rolesSelector }.AsEnumerable());
        }

        /// <inheritdoc />
        public void Apply(OpenApiOperation operation, OperationFilterContext context)
        {
            this.filter.Apply(operation, context);
        }
    }
}
